/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.manager.MacroManager;
import org.apache.maven.doxia.macro.manager.MacroNotFoundException;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.CreateAnchorsForIndexEntriesFactory;
import org.apache.maven.doxia.sink.impl.SinkWrapperFactory;
import org.apache.maven.doxia.sink.impl.SinkWrapperFactoryComparator;

public abstract class AbstractParser
implements Parser {
    private boolean secondParsing = false;
    @Inject
    private MacroManager macroManager;
    @Inject
    private Collection<SinkWrapperFactory> automaticallyRegisteredSinkWrapperFactories;
    private final Collection<SinkWrapperFactory> manuallyRegisteredSinkWrapperFactories = new LinkedList<SinkWrapperFactory>();
    private boolean emitComments = true;
    private boolean emitAnchors = false;
    private static final String DOXIA_VERSION;

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void setEmitComments(boolean emitComments) {
        this.emitComments = emitComments;
    }

    @Override
    public boolean isEmitComments() {
        return this.emitComments;
    }

    @Override
    public boolean isEmitAnchorsForIndexableEntries() {
        return this.emitAnchors;
    }

    @Override
    public void setEmitAnchorsForIndexableEntries(boolean emitAnchors) {
        this.emitAnchors = emitAnchors;
    }

    public void executeMacro(String macroId, MacroRequest request, Sink sink) throws MacroExecutionException, MacroNotFoundException {
        Macro macro = this.getMacroManager().getMacro(macroId);
        macro.execute(sink, request);
    }

    protected File getBasedir() {
        String basedir = System.getProperty("basedir");
        if (basedir != null) {
            return new File(basedir);
        }
        return new File(new File("").getAbsolutePath());
    }

    public void parse(String string, Sink sink) throws ParseException {
        this.parse(string, sink, null);
    }

    public void parse(String string, Sink sink, String reference) throws ParseException {
        this.parse(new StringReader(string), sink, reference);
    }

    @Override
    public void parse(Reader source, Sink sink) throws ParseException {
        this.parse(source, sink, null);
    }

    protected Sink getWrappedSink(Sink sink) {
        if (this.secondParsing) {
            return sink;
        }
        Sink currentSink = sink;
        for (SinkWrapperFactory factory : this.getSinkWrapperFactories()) {
            currentSink = factory.createWrapper(currentSink);
        }
        return currentSink;
    }

    public void setSecondParsing(boolean second) {
        this.secondParsing = second;
    }

    protected boolean isSecondParsing() {
        return this.secondParsing;
    }

    @Override
    public void addSinkWrapperFactory(SinkWrapperFactory factory) {
        this.manuallyRegisteredSinkWrapperFactories.add(factory);
    }

    protected List<SinkWrapperFactory> getSinkWrapperFactories() {
        ArrayList<SinkWrapperFactory> effectiveSinkWrapperFactories = new ArrayList<SinkWrapperFactory>();
        if (this.automaticallyRegisteredSinkWrapperFactories != null) {
            effectiveSinkWrapperFactories.addAll(this.automaticallyRegisteredSinkWrapperFactories);
        }
        effectiveSinkWrapperFactories.addAll(this.manuallyRegisteredSinkWrapperFactories);
        if (this.emitAnchors) {
            effectiveSinkWrapperFactories.add(new CreateAnchorsForIndexEntriesFactory());
        }
        Collections.sort(effectiveSinkWrapperFactories, Collections.reverseOrder(new SinkWrapperFactoryComparator()));
        return effectiveSinkWrapperFactories;
    }

    protected MacroManager getMacroManager() {
        return this.macroManager;
    }

    protected void init() {
    }

    protected static String doxiaVersion() {
        return DOXIA_VERSION;
    }

    static {
        Properties props = new Properties();
        InputStream is = AbstractParser.class.getResourceAsStream("/META-INF/maven/org.apache.maven.doxia/doxia-core/pom.properties");
        if (is == null) {
            props.setProperty("version", "unknown");
        } else {
            try {
                props.load(is);
            }
            catch (IOException ex) {
                props.setProperty("version", "unknown");
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        DOXIA_VERSION = props.getProperty("version");
    }
}

