/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.velocity.util.introspection.IntrospectionUtils;
import org.apache.velocity.util.introspection.TypeConversionHandler;

public class MethodMap {
    private static final int INCOMPARABLE = 0;
    private static final int MORE_SPECIFIC = 1;
    private static final int EQUIVALENT = 2;
    private static final int LESS_SPECIFIC = 3;
    private static final int NOT_CONVERTIBLE = 0;
    private static final int EXPLICITLY_CONVERTIBLE = 1;
    private static final int IMPLCITLY_CONVERTIBLE = 2;
    private static final int STRICTLY_CONVERTIBLE = 3;
    TypeConversionHandler conversionHandler;
    Map<String, List<Method>> methodByNameMap = new ConcurrentHashMap<String, List<Method>>();

    public MethodMap() {
        this(null);
    }

    public MethodMap(TypeConversionHandler conversionHandler) {
        this.conversionHandler = conversionHandler;
    }

    public void add(Method method) {
        String methodName = method.getName();
        List<Method> l = this.get(methodName);
        if (l == null) {
            l = new ArrayList<Method>();
            this.methodByNameMap.put(methodName, l);
        }
        l.add(method);
    }

    public List<Method> get(String key) {
        return this.methodByNameMap.get(key);
    }

    public Method find(String methodName, Object[] args) throws AmbiguousException {
        List<Method> methodList = this.get(methodName);
        if (methodList == null) {
            return null;
        }
        int l = args.length;
        Class[] classes = new Class[l];
        for (int i2 = 0; i2 < l; ++i2) {
            Object arg = args[i2];
            classes[i2] = arg == null ? null : arg.getClass();
        }
        return this.getBestMatch(methodList, classes);
    }

    private static boolean onlyNullOrObjects(Class<?>[] args) {
        for (Class<?> cls : args) {
            if (cls == null || cls == Object.class) continue;
            return false;
        }
        return args.length > 0;
    }

    private Method getBestMatch(List<Method> methods, Class<?>[] args) {
        LinkedList<Match> bestMatches = new LinkedList<Match>();
        Class[] unboxedArgs = new Class[args.length];
        for (int i2 = 0; i2 < args.length; ++i2) {
            unboxedArgs[i2] = IntrospectionUtils.getUnboxedClass(args[i2]);
        }
        for (Method method : methods) {
            int applicability = this.getApplicability(method, unboxedArgs);
            if (applicability <= 0) continue;
            Match match = new Match(method, applicability, unboxedArgs);
            if (bestMatches.size() == 0) {
                bestMatches.add(match);
                continue;
            }
            boolean keepMethod = true;
            ListIterator it = bestMatches.listIterator();
            while (keepMethod && it.hasNext()) {
                Match best = (Match)it.next();
                if (best.specificity == 3 && match.specificity < 2) {
                    keepMethod = false;
                    continue;
                }
                if (match.specificity == 3 && best.specificity < 2) {
                    it.remove();
                    continue;
                }
                if (best.applicability > match.applicability) {
                    keepMethod = false;
                    continue;
                }
                if (best.applicability < match.applicability) {
                    it.remove();
                    continue;
                }
                if (MethodMap.onlyNullOrObjects(args)) {
                    if (match.varargs == best.varargs) continue;
                    if (match.varargs) {
                        keepMethod = false;
                        continue;
                    }
                    if (!best.varargs) continue;
                    it.remove();
                    continue;
                }
                switch (this.compare(match.methodTypes, best.methodTypes)) {
                    case 3: {
                        keepMethod = false;
                        break;
                    }
                    case 1: {
                        it.remove();
                        break;
                    }
                    case 0: {
                        if (match.varargs == best.varargs) break;
                        if (match.varargs) {
                            keepMethod = false;
                            break;
                        }
                        if (!best.varargs) break;
                        it.remove();
                        break;
                    }
                }
            }
            if (!keepMethod) continue;
            bestMatches.add(match);
        }
        switch (bestMatches.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return MethodMap.getTopMostMethodDeclaration(((Match)bestMatches.get((int)0)).method);
            }
        }
        throw new AmbiguousException();
    }

    public static Method getTopMostMethodDeclaration(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        String name = method.getName();
        Class<?>[] arguments = method.getParameterTypes();
        while (clazz != null) {
            Class<?> superClass = null;
            Method superMethod = null;
            superClass = clazz.getSuperclass();
            if (superClass != null) {
                try {
                    superMethod = superClass.getDeclaredMethod(name, arguments);
                    if ((superMethod.getModifiers() & 1) == 0) {
                        superMethod = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (superMethod == null) {
                Class<?>[] interfaces;
                for (Class<?> intf : interfaces = clazz.getInterfaces()) {
                    try {
                        superMethod = intf.getDeclaredMethod(name, arguments);
                        if (superMethod == null) continue;
                        superClass = intf;
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (superMethod != null) {
                method = superMethod;
            }
            clazz = superClass;
        }
        return method;
    }

    private int compare(Type[] t1, Type[] t2) {
        boolean last2Array;
        int i2;
        Type itemType;
        boolean t1IsVararag = false;
        boolean t2IsVararag = false;
        boolean fixedLengths = false;
        if (t1.length > t2.length) {
            int l2 = t2.length;
            if (l2 == 0) {
                return 1;
            }
            itemType = TypeUtils.getArrayComponentType((t2 = Arrays.copyOf(t2, t1.length))[l2 - 1]);
            if (itemType == null) {
                t1IsVararag = true;
                t2[t1.length - 1] = null;
            } else {
                t2IsVararag = true;
                for (i2 = l2 - 1; i2 < t1.length; ++i2) {
                    t2[i2] = itemType;
                }
            }
            fixedLengths = true;
        } else if (t2.length > t1.length) {
            int l1 = t1.length;
            if (l1 == 0) {
                return 3;
            }
            itemType = TypeUtils.getArrayComponentType((t1 = Arrays.copyOf(t1, t2.length))[l1 - 1]);
            if (itemType == null) {
                t2IsVararag = true;
                t1[t2.length - 1] = null;
            } else {
                t1IsVararag = true;
                for (i2 = l1 - 1; i2 < t2.length; ++i2) {
                    t1[i2] = itemType;
                }
            }
            fixedLengths = true;
        }
        int fromC1toC2 = 3;
        int fromC2toC1 = 3;
        for (i2 = 0; i2 < t1.length; ++i2) {
            boolean last;
            Class<?> c1 = t1[i2] == null ? null : IntrospectionUtils.getTypeClass(t1[i2]);
            Class<?> c2 = t2[i2] == null ? null : IntrospectionUtils.getTypeClass(t2[i2]);
            boolean bl = last = !fixedLengths && i2 == t1.length - 1;
            if (!(t1[i2] == null && t2[i2] != null || t1[i2] != null && t2[i2] == null) && t1[i2].equals(t2[i2])) continue;
            if (t1[i2] == null) {
                fromC2toC1 = 0;
                if (c2 == null || !c2.isPrimitive()) continue;
                fromC1toC2 = 0;
                continue;
            }
            if (t2[i2] == null) {
                fromC1toC2 = 0;
                if (c1 == null || !c1.isPrimitive()) continue;
                fromC2toC1 = 0;
                continue;
            }
            if (c1 != null) {
                switch (fromC1toC2) {
                    case 3: {
                        if (MethodMap.isStrictConvertible(t2[i2], c1, last)) break;
                        fromC1toC2 = 2;
                    }
                    case 2: {
                        if (this.isConvertible(t2[i2], c1, last)) break;
                        fromC1toC2 = 1;
                    }
                    case 1: {
                        if (this.isExplicitlyConvertible(t2[i2], c1, last)) break;
                        fromC1toC2 = 0;
                    }
                }
            } else if (fromC1toC2 > 0) {
                int n = fromC1toC2 = TypeUtils.isAssignable(t1[i2], t2[i2]) ? Math.min(fromC1toC2, 2) : 0;
            }
            if (c2 != null) {
                switch (fromC2toC1) {
                    case 3: {
                        if (MethodMap.isStrictConvertible(t1[i2], c2, last)) break;
                        fromC2toC1 = 2;
                    }
                    case 2: {
                        if (this.isConvertible(t1[i2], c2, last)) break;
                        fromC2toC1 = 1;
                    }
                    case 1: {
                        if (this.isExplicitlyConvertible(t1[i2], c2, last)) break;
                        fromC2toC1 = 0;
                    }
                }
                continue;
            }
            if (fromC2toC1 <= 0) continue;
            fromC2toC1 = TypeUtils.isAssignable(t2[i2], t1[i2]) ? Math.min(fromC2toC1, 2) : 0;
        }
        if (fromC1toC2 == 0 && fromC2toC1 == 0) {
            return 0;
        }
        if (fromC1toC2 > fromC2toC1) {
            return 1;
        }
        if (fromC2toC1 > fromC1toC2) {
            return 3;
        }
        boolean last1Array = t1IsVararag || !fixedLengths && TypeUtils.isArrayType(t1[t1.length - 1]);
        boolean bl = last2Array = t2IsVararag || !fixedLengths && TypeUtils.isArrayType(t2[t2.length - 1]);
        if (last1Array && !last2Array) {
            return 3;
        }
        if (!last1Array && last2Array) {
            return 1;
        }
        return 2;
    }

    private int getApplicability(Method method, Class<?>[] classes) {
        Type[] methodArgs = method.getGenericParameterTypes();
        int ret = 3;
        if (methodArgs.length > classes.length) {
            if (methodArgs.length == classes.length + 1 && TypeUtils.isArrayType(methodArgs[methodArgs.length - 1])) {
                for (int i2 = 0; i2 < classes.length; ++i2) {
                    if (MethodMap.isStrictConvertible(methodArgs[i2], classes[i2], false)) continue;
                    if (this.isConvertible(methodArgs[i2], classes[i2], false)) {
                        ret = Math.min(ret, 2);
                        continue;
                    }
                    if (this.isExplicitlyConvertible(methodArgs[i2], classes[i2], false)) {
                        ret = Math.min(ret, 1);
                        continue;
                    }
                    return 0;
                }
                return ret;
            }
            return 0;
        }
        if (methodArgs.length == classes.length) {
            for (int i3 = 0; i3 < classes.length; ++i3) {
                boolean possibleVararg;
                boolean bl = possibleVararg = i3 == classes.length - 1 && TypeUtils.isArrayType(methodArgs[i3]);
                if (MethodMap.isStrictConvertible(methodArgs[i3], classes[i3], possibleVararg)) continue;
                if (this.isConvertible(methodArgs[i3], classes[i3], possibleVararg)) {
                    ret = Math.min(ret, 2);
                    continue;
                }
                if (this.isExplicitlyConvertible(methodArgs[i3], classes[i3], possibleVararg)) {
                    ret = Math.min(ret, 1);
                    continue;
                }
                return 0;
            }
            return ret;
        }
        if (methodArgs.length > 0) {
            Type lastarg = methodArgs[methodArgs.length - 1];
            if (!TypeUtils.isArrayType(lastarg)) {
                return 0;
            }
            for (int i4 = 0; i4 < methodArgs.length - 1; ++i4) {
                if (MethodMap.isStrictConvertible(methodArgs[i4], classes[i4], false)) continue;
                if (this.isConvertible(methodArgs[i4], classes[i4], false)) {
                    ret = Math.min(ret, 2);
                    continue;
                }
                if (this.isExplicitlyConvertible(methodArgs[i4], classes[i4], false)) {
                    ret = Math.min(ret, 1);
                    continue;
                }
                return 0;
            }
            Type vararg = TypeUtils.getArrayComponentType(lastarg);
            for (int i5 = methodArgs.length - 1; i5 < classes.length; ++i5) {
                if (MethodMap.isStrictConvertible(vararg, classes[i5], false)) continue;
                if (this.isConvertible(vararg, classes[i5], false)) {
                    ret = Math.min(ret, 2);
                    continue;
                }
                if (this.isExplicitlyConvertible(vararg, classes[i5], false)) {
                    ret = Math.min(ret, 1);
                    continue;
                }
                return 0;
            }
            return ret;
        }
        return 0;
    }

    private boolean isConvertible(Type formal, Class<?> actual, boolean possibleVarArg) {
        return IntrospectionUtils.isMethodInvocationConvertible(formal, actual, possibleVarArg);
    }

    private static boolean isStrictConvertible(Type formal, Class<?> actual, boolean possibleVarArg) {
        return IntrospectionUtils.isStrictMethodInvocationConvertible(formal, actual, possibleVarArg);
    }

    private boolean isExplicitlyConvertible(Type formal, Class<?> actual, boolean possibleVarArg) {
        return this.conversionHandler != null && this.conversionHandler.isExplicitlyConvertible(formal, actual, possibleVarArg);
    }

    public static class AmbiguousException
    extends RuntimeException {
        private static final long serialVersionUID = -2314636505414551663L;
    }

    private class Match {
        Method method;
        Type[] methodTypes;
        int specificity;
        int applicability;
        boolean varargs;

        Match(Method method, int applicability, Class<?>[] unboxedArgs) {
            this.method = method;
            this.applicability = applicability;
            this.methodTypes = method.getGenericParameterTypes();
            this.specificity = MethodMap.this.compare(this.methodTypes, unboxedArgs);
            this.varargs = this.methodTypes.length > 0 && TypeUtils.isArrayType(this.methodTypes[this.methodTypes.length - 1]);
        }
    }
}

