/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.Base64;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class ProjectInfoReportUtils {
    private static final UrlValidator URL_VALIDATOR = new UrlValidator(new String[]{"http", "https"}, new RegexValidator("^([\\p{Alnum}\\-\\.]*)(:\\d*)?(.*)?"), 0L);
    private static final int TIMEOUT = 5000;

    public static String getContent(URL url, Settings settings) throws IOException {
        return ProjectInfoReportUtils.getContent(url, settings, "UTF-8");
    }

    public static String getContent(URL url, Settings settings, String encoding) throws IOException {
        return ProjectInfoReportUtils.getContent(url, null, settings, encoding);
    }

    public static String getContent(URL url, MavenProject project, Settings settings, String encoding) throws IOException {
        String scheme = url.getProtocol();
        if (encoding == null || encoding.isEmpty()) {
            encoding = "UTF-8";
        }
        if ("file".equals(scheme)) {
            try (InputStream in = url.openConnection().getInputStream();){
                String content;
                String string = content = IOUtil.toString(in, encoding);
                return string;
            }
        }
        Proxy proxy = settings.getActiveProxy();
        if (proxy != null) {
            scheme = "http".equals(scheme) || "https".equals(scheme) || "ftp".equals(scheme) ? scheme + "." : "";
            String host = proxy.getHost();
            if (host != null && !host.isEmpty()) {
                String userName;
                Properties p = System.getProperties();
                p.setProperty(scheme + "proxySet", "true");
                p.setProperty(scheme + "proxyHost", host);
                p.setProperty(scheme + "proxyPort", String.valueOf(proxy.getPort()));
                if (!StringUtils.isEmpty(proxy.getNonProxyHosts())) {
                    p.setProperty(scheme + "nonProxyHosts", proxy.getNonProxyHosts());
                }
                if ((userName = proxy.getUsername()) != null && !userName.isEmpty()) {
                    final String pwd = StringUtils.isEmpty(proxy.getPassword()) ? "" : proxy.getPassword();
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(userName, pwd.toCharArray());
                        }
                    });
                }
            }
        }
        try (InputStream in = ProjectInfoReportUtils.getURLConnection(url, project, settings).getInputStream();){
            String string = IOUtil.toString(in, encoding);
            return string;
        }
    }

    public static String getProjectUrl(MavenProject project) {
        if (project != null && ProjectInfoReportUtils.isArtifactUrlValid(project.getUrl())) {
            return project.getUrl();
        }
        return null;
    }

    public static String getArtifactIdCell(String artifactId, String link) {
        if (link == null || link.isEmpty()) {
            return artifactId;
        }
        return "{" + artifactId + "," + link + "}";
    }

    public static boolean isArtifactUrlValid(String url) {
        if (url == null || url.isEmpty()) {
            return false;
        }
        return URL_VALIDATOR.isValid(url);
    }

    public static String getArchiveServer(String uri) {
        if (uri == null) {
            return "???UNKNOWN???";
        }
        return URI.create(uri).getHost();
    }

    private static URLConnection getURLConnection(URL url, MavenProject project, Settings settings) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        if (!(settings.getServers() == null || settings.getServers().isEmpty() || project == null || project.getDistributionManagement() == null || project.getDistributionManagement().getRepository() == null && project.getDistributionManagement().getSnapshotRepository() == null || !StringUtils.isNotEmpty(project.getDistributionManagement().getRepository().getUrl()) && !StringUtils.isNotEmpty(project.getDistributionManagement().getSnapshotRepository().getUrl()))) {
            Server server = null;
            if (url.toString().contains(project.getDistributionManagement().getRepository().getUrl())) {
                server = settings.getServer(project.getDistributionManagement().getRepository().getId());
            }
            if (server == null && url.toString().contains(project.getDistributionManagement().getSnapshotRepository().getUrl())) {
                server = settings.getServer(project.getDistributionManagement().getSnapshotRepository().getId());
            }
            if (server != null && StringUtils.isNotEmpty(server.getUsername()) && StringUtils.isNotEmpty(server.getPassword())) {
                String up = server.getUsername().trim() + ":" + server.getPassword().trim();
                String upEncoded = new String(Base64.encodeBase64Chunked(up.getBytes())).trim();
                conn.setRequestProperty("Authorization", "Basic " + upEncoded);
            }
        }
        if (conn instanceof HttpsURLConnection) {
            HostnameVerifier hostnameverifier = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            ((HttpsURLConnection)conn).setHostnameVerifier(hostnameverifier);
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
            }
            catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
                // empty catch block
            }
        }
        return conn;
    }
}

