/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ModuleExports;
import org.apache.bcel.classfile.ModuleOpens;
import org.apache.bcel.classfile.ModuleProvides;
import org.apache.bcel.classfile.ModuleRequires;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class Module
extends Attribute {
    public static final String EXTENSION = ".jmod";
    private final int moduleNameIndex;
    private final int moduleFlags;
    private final int moduleVersionIndex;
    private ModuleRequires[] requiresTable;
    private ModuleExports[] exportsTable;
    private ModuleOpens[] opensTable;
    private final int usesCount;
    private final int[] usesIndex;
    private ModuleProvides[] providesTable;

    private static String getClassNameAtIndex(ConstantPool cp, int index, boolean compactClassName) {
        String className = cp.getConstantString(index, (byte)7);
        if (compactClassName) {
            return Utility.compactClassName(className, false);
        }
        return className;
    }

    Module(int nameIndex, int length, DataInput input, ConstantPool constantPool) throws IOException {
        super((byte)22, nameIndex, length, constantPool);
        int i2;
        this.moduleNameIndex = input.readUnsignedShort();
        this.moduleFlags = input.readUnsignedShort();
        this.moduleVersionIndex = input.readUnsignedShort();
        int requiresCount = input.readUnsignedShort();
        this.requiresTable = new ModuleRequires[requiresCount];
        for (int i3 = 0; i3 < requiresCount; ++i3) {
            this.requiresTable[i3] = new ModuleRequires(input);
        }
        int exportsCount = input.readUnsignedShort();
        this.exportsTable = new ModuleExports[exportsCount];
        for (int i4 = 0; i4 < exportsCount; ++i4) {
            this.exportsTable[i4] = new ModuleExports(input);
        }
        int opensCount = input.readUnsignedShort();
        this.opensTable = new ModuleOpens[opensCount];
        for (i2 = 0; i2 < opensCount; ++i2) {
            this.opensTable[i2] = new ModuleOpens(input);
        }
        this.usesCount = input.readUnsignedShort();
        this.usesIndex = new int[this.usesCount];
        for (i2 = 0; i2 < this.usesCount; ++i2) {
            this.usesIndex[i2] = input.readUnsignedShort();
        }
        int providesCount = input.readUnsignedShort();
        this.providesTable = new ModuleProvides[providesCount];
        for (int i5 = 0; i5 < providesCount; ++i5) {
            this.providesTable[i5] = new ModuleProvides(input);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModule(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        Module c = (Module)this.clone();
        c.requiresTable = new ModuleRequires[this.requiresTable.length];
        Arrays.setAll(c.requiresTable, i2 -> this.requiresTable[i2].copy());
        c.exportsTable = new ModuleExports[this.exportsTable.length];
        Arrays.setAll(c.exportsTable, i2 -> this.exportsTable[i2].copy());
        c.opensTable = new ModuleOpens[this.opensTable.length];
        Arrays.setAll(c.opensTable, i2 -> this.opensTable[i2].copy());
        c.providesTable = new ModuleProvides[this.providesTable.length];
        Arrays.setAll(c.providesTable, i2 -> this.providesTable[i2].copy());
        c.setConstantPool(constantPool);
        return c;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.moduleNameIndex);
        file.writeShort(this.moduleFlags);
        file.writeShort(this.moduleVersionIndex);
        file.writeShort(this.requiresTable.length);
        for (ModuleRequires moduleRequires : this.requiresTable) {
            moduleRequires.dump(file);
        }
        file.writeShort(this.exportsTable.length);
        for (ModuleExports moduleExports : this.exportsTable) {
            moduleExports.dump(file);
        }
        file.writeShort(this.opensTable.length);
        for (ModuleOpens moduleOpens : this.opensTable) {
            moduleOpens.dump(file);
        }
        file.writeShort(this.usesIndex.length);
        for (int n : this.usesIndex) {
            file.writeShort(n);
        }
        file.writeShort(this.providesTable.length);
        for (ModuleProvides moduleProvides : this.providesTable) {
            moduleProvides.dump(file);
        }
    }

    public ModuleExports[] getExportsTable() {
        return this.exportsTable;
    }

    public int getModuleFlags() {
        return this.moduleFlags;
    }

    public String getModuleName(ConstantPool cp) {
        return cp.getConstantString(this.moduleNameIndex, (byte)19);
    }

    public ModuleOpens[] getOpensTable() {
        return this.opensTable;
    }

    public ModuleProvides[] getProvidesTable() {
        return this.providesTable;
    }

    public ModuleRequires[] getRequiresTable() {
        return this.requiresTable;
    }

    public String[] getUsedClassNames(ConstantPool constantPool, boolean compactClassName) {
        String[] usedClassNames = new String[this.usesCount];
        for (int i2 = 0; i2 < this.usesCount; ++i2) {
            usedClassNames[i2] = Module.getClassNameAtIndex(constantPool, this.usesIndex[i2], compactClassName);
        }
        return usedClassNames;
    }

    public String getVersion(ConstantPool cp) {
        return this.moduleVersionIndex == 0 ? "0" : cp.getConstantString(this.moduleVersionIndex, (byte)1);
    }

    @Override
    public String toString() {
        ConstantPool cp = super.getConstantPool();
        StringBuilder buf = new StringBuilder();
        buf.append("Module:\n");
        buf.append("  name:    ").append(Utility.pathToPackage(this.getModuleName(cp))).append("\n");
        buf.append("  flags:   ").append(String.format("%04x", this.moduleFlags)).append("\n");
        String version = this.getVersion(cp);
        buf.append("  version: ").append(version).append("\n");
        buf.append("  requires(").append(this.requiresTable.length).append("):\n");
        for (ModuleRequires moduleRequires : this.requiresTable) {
            buf.append("    ").append(moduleRequires.toString(cp)).append("\n");
        }
        buf.append("  exports(").append(this.exportsTable.length).append("):\n");
        for (ModuleExports moduleExports : this.exportsTable) {
            buf.append("    ").append(moduleExports.toString(cp)).append("\n");
        }
        buf.append("  opens(").append(this.opensTable.length).append("):\n");
        for (ModuleOpens moduleOpens : this.opensTable) {
            buf.append("    ").append(moduleOpens.toString(cp)).append("\n");
        }
        buf.append("  uses(").append(this.usesIndex.length).append("):\n");
        for (int n : this.usesIndex) {
            String className = Module.getClassNameAtIndex(cp, n, true);
            buf.append("    ").append(className).append("\n");
        }
        buf.append("  provides(").append(this.providesTable.length).append("):\n");
        for (ModuleProvides moduleProvides : this.providesTable) {
            buf.append("    ").append(moduleProvides.toString(cp)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }
}

