/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.Dumpable;
import net.messagevortex.asn1.SymmetricKey;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERTaggedObject;

public class BlendingParameter
extends AbstractBlock
implements Serializable,
Dumpable {
    public static final long serialVersionUID = 100000000004L;
    int offset = -1;
    SymmetricKey symmetricKey = null;

    public BlendingParameter(ASN1Encodable e) throws IOException {
        this.parse(e);
    }

    public BlendingParameter(BlendingParameterChoice choice) throws IOException {
        if (choice == BlendingParameterChoice.OFFSET) {
            this.offset = 0;
        } else {
            this.symmetricKey = new SymmetricKey();
        }
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        ASN1TaggedObject t = ASN1TaggedObject.getInstance(to);
        if (to == null || t == null) {
            throw new IOException("unknown blender parameter choice detected (tagged object is null)");
        }
        BlendingParameterChoice bpc = BlendingParameterChoice.getById(t.getTagNo());
        if (bpc == null) {
            throw new IOException("unknown blender parameter choice detected (" + t.getTagNo() + ")");
        }
        switch (bpc) {
            case OFFSET: {
                this.offset = ASN1Integer.getInstance(t.getBaseObject()).getValue().intValue();
                break;
            }
            case F5: {
                this.symmetricKey = new SymmetricKey(t.getBaseObject().getEncoded());
                break;
            }
            default: {
                throw new IOException("unknown blender parameter choice detected (" + t.getTagNo() + ")");
            }
        }
    }

    public BlendingParameterChoice getChoice() {
        if (this.offset > -1) {
            return BlendingParameterChoice.OFFSET;
        }
        if (this.symmetricKey != null) {
            return BlendingParameterChoice.F5;
        }
        return null;
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumptype) throws IOException {
        StringBuilder sb = new StringBuilder();
        switch (this.getChoice()) {
            case OFFSET: {
                sb.append("offset ").append(this.offset);
                break;
            }
            case F5: {
                sb.append("symmetricKey ").append(this.symmetricKey.dumpValueNotation(prefix, dumptype));
                break;
            }
            default: {
                throw new IOException("unable to dump " + String.valueOf((Object)this.getChoice()));
            }
        }
        return sb.toString();
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        switch (this.getChoice()) {
            case OFFSET: {
                return new DERTaggedObject(this.getChoice().getId(), new ASN1Integer(this.offset));
            }
            case F5: {
                return new DERTaggedObject(this.getChoice().getId(), this.symmetricKey.toAsn1Object(dumpType));
            }
        }
        throw new IOException("unable to convert to ASN.1 (" + String.valueOf((Object)this.getChoice()) + ")");
    }

    public boolean equals(Object t) {
        if (t == null || t.getClass() != this.getClass()) {
            return false;
        }
        BlendingParameter o = (BlendingParameter)t;
        try {
            return this.dumpValueNotation("", DumpType.ALL).equals(o.dumpValueNotation("", DumpType.ALL));
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.dumpValueNotation("", DumpType.ALL).hashCode();
        }
        catch (IOException ioe) {
            return "FAILED".hashCode();
        }
    }

    public static enum BlendingParameterChoice {
        OFFSET(1),
        F5(2);

        final int id;

        private BlendingParameterChoice(int i2) {
            this.id = i2;
        }

        public static BlendingParameterChoice getById(int i2) {
            for (BlendingParameterChoice e : BlendingParameterChoice.values()) {
                if (e.id != i2) continue;
                return e;
            }
            return null;
        }

        public int getId() {
            return this.id;
        }
    }
}

