/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.messagevortex.ExtendedSecureRandom;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AlgorithmParameter;
import net.messagevortex.asn1.AsymmetricKeyPreCalculator;
import net.messagevortex.asn1.Dumpable;
import net.messagevortex.asn1.Key;
import net.messagevortex.asn1.encryption.Algorithm;
import net.messagevortex.asn1.encryption.AlgorithmType;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.asn1.encryption.Mode;
import net.messagevortex.asn1.encryption.Padding;
import net.messagevortex.asn1.encryption.Parameter;
import net.messagevortex.asn1.encryption.SecurityLevel;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;

public class AsymmetricKey
extends Key
implements Serializable,
Dumpable {
    public static final long serialVersionUID = 100000000032L;
    private static final int PUBLIC_KEY_TAG = 2;
    private static final int PRIVATE_KEY_TAG = 3;
    private static final Logger LOGGER;
    protected byte[] publicKey = null;
    protected byte[] privateKey = null;

    public AsymmetricKey(byte[] b) throws IOException {
        this(ASN1Sequence.getInstance(b));
        this.selftest();
    }

    public AsymmetricKey(AsymmetricKey ak) {
        try {
            this.parse(ak.toAsn1Object(DumpType.ALL));
            this.selftest();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Error cloning key", ioe);
        }
    }

    private AsymmetricKey(ASN1Encodable to) throws IOException {
        this.parse(to);
        this.selftest();
    }

    public AsymmetricKey() throws IOException {
        this(Algorithm.getDefault(AlgorithmType.ASYMMETRIC).getParameters(SecurityLevel.MEDIUM));
        this.selftest();
    }

    public AsymmetricKey(AlgorithmParameter params) throws IOException {
        this(params, true);
    }

    public AsymmetricKey(AlgorithmParameter params, boolean allowPrecalculated) throws IOException {
        if (params == null) {
            throw new NullPointerException("parameters may not be null");
        }
        this.parameters = new AlgorithmParameter(params.toAsn1Object(DumpType.INTERNAL));
        if (params.get(Parameter.ALGORITHM) == null) {
            throw new IOException("Algorithm null is not encodable by the system");
        }
        this.createKey(allowPrecalculated);
        this.selftest();
    }

    public static String setCacheFileName(String name) {
        return AsymmetricKeyPreCalculator.setCacheFileName(name);
    }

    public static String getCacheFileName() {
        return AsymmetricKeyPreCalculator.getCacheFileName();
    }

    private final void selftest() throws IOException {
        if (this.publicKey == null) {
            throw new IOException("selftest failed: Public key may not be null");
        }
        assert (this.getAlgorithm() != Algorithm.EC || this.parameters.get(Parameter.CURVETYPE).indexOf(this.parameters.get(Parameter.BLOCKSIZE)) > 0) : "found mismatch in curve type vs blocksize (" + this.parameters.get(Parameter.BLOCKSIZE) + "/" + this.parameters.get(Parameter.CURVETYPE) + ")";
        assert (this.getAlgorithm() != Algorithm.RSA || this.parameters.get(Parameter.KEYSIZE).equals(this.parameters.get(Parameter.BLOCKSIZE))) : "found mismatch in RSA keysize vs blocksize (ks:" + this.parameters.get(Parameter.KEYSIZE) + "/bs:" + this.parameters.get(Parameter.BLOCKSIZE) + ")";
    }

    private void createKey(boolean allowPrecomputed) throws IOException {
        AsymmetricKey tk;
        assert (this.parameters != null);
        Algorithm alg = Algorithm.getByString(this.parameters.get(Parameter.ALGORITHM));
        assert (alg != null);
        if (allowPrecomputed && (tk = AsymmetricKeyPreCalculator.getPrecomputedAsymmetricKey(this.parameters)) != null) {
            assert (this.getKeySize() == tk.getKeySize());
            this.publicKey = tk.publicKey;
            this.privateKey = tk.privateKey;
            return;
        }
        if ("RSA".equals(alg.name())) {
            this.createRsaKey();
        } else if (alg == Algorithm.EC) {
            this.createEcKey();
        } else {
            throw new IOException("Encountered unsupported algorithm \"" + String.valueOf(alg) + "\"");
        }
    }

    private void createRsaKey() throws IOException {
        Algorithm alg = Algorithm.getByString(this.parameters.get(Parameter.ALGORITHM));
        int keySize = this.getKeySize();
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(alg.toString(), alg.getProvider());
            keyGen.initialize(keySize);
            KeyPair pair = keyGen.genKeyPair();
            this.publicKey = pair.getPublic().getEncoded();
            this.privateKey = pair.getPrivate().getEncoded();
        }
        catch (IllegalStateException ise) {
            throw new IllegalStateException("unable to generate keys with " + String.valueOf(alg) + "/" + this.parameters.get(Parameter.MODE) + "/" + this.parameters.get(Parameter.PADDING) + " (size " + keySize + ")", ise);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IOException("Exception while generating key pair", e);
        }
    }

    private void createEcKey() throws IOException {
        Algorithm alg = Algorithm.getByString(this.parameters.get(Parameter.ALGORITHM));
        try {
            if (this.parameters.get(Parameter.CURVETYPE) == null) {
                throw new IOException("curve type is not set");
            }
            ECNamedCurveParameterSpec ecpara = ECNamedCurveTable.getParameterSpec(this.parameters.get(Parameter.CURVETYPE));
            KeyPairGenerator g = KeyPairGenerator.getInstance(alg.getAlgorithmFamily(), "BC");
            g.initialize(ecpara, ExtendedSecureRandom.getSecureRandom());
            KeyPair pair = g.generateKeyPair();
            this.publicKey = pair.getPublic().getEncoded();
            this.privateKey = pair.getPrivate().getEncoded();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IOException("Exception while initializing key generation", e);
        }
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        ASN1Sequence s1 = ASN1Sequence.getInstance(to);
        int i2 = 0;
        this.parseKeyParameter(ASN1Sequence.getInstance(s1.getObjectAt(i2++)));
        ASN1TaggedObject tagged = (ASN1TaggedObject)s1.getObjectAt(i2++);
        if (tagged.getTagNo() != 2) {
            throw new IOException("encountered wrong tag number when parsing public key (expected: 2; got:" + tagged.getTagNo() + ")");
        }
        this.publicKey = ASN1OctetString.getInstance(tagged.getBaseObject()).getOctets();
        if (s1.size() > i2) {
            if ((tagged = (ASN1TaggedObject)s1.getObjectAt(i2++)).getTagNo() != 3) {
                throw new IOException("encountered wrong tag number when parsing private key (expected: 3; got:" + tagged.getTagNo() + ")");
            }
            this.privateKey = ASN1OctetString.getInstance(tagged.getBaseObject()).getOctets();
        }
    }

    public boolean hasPrivateKey() {
        return this.privateKey != null;
    }

    public String dumpValueNotation(String prefix) {
        return this.dumpValueNotation(prefix, DumpType.PUBLIC_ONLY);
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\r\n");
        sb.append(this.dumpKeyTypeValueNotation(prefix + "  ", dumpType)).append(',').append("\r\n");
        String s = AsymmetricKey.toHex(this.publicKey);
        sb.append(prefix).append("  publicKey ").append(s);
        if (this.privateKey != null && this.privateKey.length != 0) {
            switch (dumpType) {
                case ALL: 
                case ALL_UNENCRYPTED: 
                case PRIVATE_COMMENTED: {
                    this.dumpPrivateKey(sb, dumpType, prefix + "  ");
                    break;
                }
            }
        } else {
            sb.append("\r\n");
        }
        sb.append(prefix).append('}');
        return sb.toString();
    }

    private void dumpPrivateKey(StringBuilder sb, DumpType dumpType, String prefix) {
        if (dumpType != DumpType.PRIVATE_COMMENTED) {
            sb.append(',');
        }
        sb.append("\r\n");
        String s = AsymmetricKey.toHex(this.privateKey);
        sb.append(prefix);
        if (dumpType == DumpType.PRIVATE_COMMENTED) {
            sb.append("-- ");
        }
        sb.append("privateKey ").append(s).append("\r\n");
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dt) throws IOException {
        if (this.publicKey == null) {
            throw new IOException("publicKey may not be null when dumping");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        this.addToAsn1Parameter(v, dt);
        this.addToAsn1PublicKey(v, dt);
        this.addToAsn1PrivateKey(v, dt);
        return new DERSequence(v);
    }

    private void addToAsn1Parameter(ASN1EncodableVector v, DumpType dumpType) throws IOException {
        v.add(this.encodeKeyParameter(dumpType));
    }

    private void addToAsn1PublicKey(ASN1EncodableVector v, DumpType dt) {
        v.add(new DERTaggedObject(true, 2, (ASN1Encodable)new DEROctetString(this.publicKey)));
    }

    private void addToAsn1PrivateKey(ASN1EncodableVector v, DumpType dt) {
        if (this.privateKey != null && (dt == DumpType.ALL || dt == DumpType.ALL_UNENCRYPTED)) {
            v.add(new DERTaggedObject(true, 3, (ASN1Encodable)new DEROctetString(this.privateKey)));
        }
    }

    @Override
    public byte[] encrypt(byte[] b) throws IOException {
        try {
            KeyPair key = this.getKeyPair();
            Cipher cipher = this.getCipher();
            PublicKey k = key.getPublic();
            cipher.init(1, k);
            return cipher.doFinal(b);
        }
        catch (InvalidKeySpecException e) {
            throw new IOException("Exception while getting key pair", e);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IOException("Exception while encrypting (len: " + b.length + ")", e);
        }
        catch (InvalidKeyException e) {
            throw new IOException("Exception while init of cipher ", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] b) throws IOException {
        try {
            KeyPair key = this.getKeyPair();
            Cipher cipher = this.getCipher();
            PrivateKey k = key.getPrivate();
            cipher.init(2, k);
            return cipher.doFinal(b);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IOException("Exception while decrypting (len: " + b.length + ")", e);
        }
    }

    public byte[] sign(byte[] b) throws IOException {
        return this.sign(b, Algorithm.getDefault(AlgorithmType.HASHING));
    }

    public byte[] sign(byte[] b, Algorithm mac) throws IOException {
        try {
            KeyPair key = this.getKeyPair();
            Signature signature = this.getSignature(mac);
            signature.initSign(key.getPrivate());
            signature.update(b);
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | InvalidKeySpecException e) {
            throw new IOException("Exception while encrypting", e);
        }
    }

    public boolean verify(byte[] b, byte[] sig) throws IOException {
        return this.verify(b, sig, Algorithm.getDefault(AlgorithmType.HASHING));
    }

    public boolean verify(byte[] b, byte[] sig, Algorithm mac) throws IOException {
        try {
            KeyPair key = this.getKeyPair();
            Signature signature = this.getSignature(mac);
            signature.initVerify(key.getPublic());
            signature.update(b);
            return signature.verify(sig);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | InvalidKeySpecException e) {
            throw new IOException("Exception while verifying signature", e);
        }
    }

    private KeyFactory getKeyFactory() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (this.parameters.get(Parameter.ALGORITHM).startsWith(Algorithm.EC.toString())) {
            return KeyFactory.getInstance("ECDSA", "BC");
        }
        Algorithm alg = Algorithm.getByString(this.parameters.get(Parameter.ALGORITHM));
        return KeyFactory.getInstance(alg.toString(), alg.getProvider());
    }

    public static double setDequeueProbability(double probability) {
        return AsymmetricKeyPreCalculator.setDequeueProbability(probability);
    }

    public static double getDequeueProbability() {
        return AsymmetricKeyPreCalculator.getDequeueProbability();
    }

    private KeyPair getKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        KeyFactory kf = this.getKeyFactory();
        PublicKey localPublicKey = kf.generatePublic(new X509EncodedKeySpec(this.publicKey));
        PrivateKey localPrivateKey = null;
        if (this.privateKey != null) {
            localPrivateKey = kf.generatePrivate(new PKCS8EncodedKeySpec(this.privateKey));
        }
        return new KeyPair(localPublicKey, localPrivateKey);
    }

    private Cipher getCipher() throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        Algorithm alg = this.getAlgorithm();
        if (alg == Algorithm.EC) {
            return Cipher.getInstance(alg.getAlgorithmFamily(), alg.getProvider());
        }
        return Cipher.getInstance(String.valueOf(alg) + "/" + String.valueOf((Object)this.getMode()) + "/" + String.valueOf(this.getPadding()), alg.getProvider());
    }

    private Signature getSignature(Algorithm a) throws NoSuchAlgorithmException, NoSuchProviderException {
        Algorithm alg = this.getAlgorithm();
        if (alg == Algorithm.EC) {
            return Signature.getInstance(String.valueOf(a) + "WithECDSA", alg.getProvider());
        }
        return Signature.getInstance(String.valueOf(a) + "With" + String.valueOf(alg), alg.getProvider());
    }

    public byte[] setPublicKey(byte[] b) {
        if (b == null) {
            throw new NullPointerException("Public key may not be null");
        }
        byte[] old = Arrays.copyOf(this.publicKey, this.publicKey.length);
        this.publicKey = Arrays.copyOf(b, b.length);
        return old;
    }

    public byte[] getPublicKey() {
        return Arrays.copyOf(this.publicKey, this.publicKey.length);
    }

    public byte[] setPrivateKey(byte[] b) {
        byte[] old = this.privateKey;
        this.privateKey = (byte[])(b == null ? null : Arrays.copyOf(b, b.length));
        return old;
    }

    public byte[] getPrivateKey() {
        return Arrays.copyOf(this.privateKey, this.privateKey.length);
    }

    public Algorithm getAlgorithm() {
        return Algorithm.getByString(this.parameters.get(Parameter.ALGORITHM));
    }

    public AlgorithmParameter getAlgorithmParameter() {
        try {
            return new AlgorithmParameter(this.parameters.toAsn1Object(DumpType.INTERNAL));
        }
        catch (IOException ex) {
            throw new IllegalStateException("parameter structure not clonable", ex);
        }
    }

    public Padding getPadding() {
        Padding padding = Padding.getByString(this.parameters.get(Parameter.PADDING));
        return padding == null ? Padding.getDefault(AlgorithmType.ASYMMETRIC) : padding;
    }

    public Padding setPadding(Padding p) {
        Padding old = this.getPadding();
        this.parameters.put(Parameter.PADDING.getId(), p.toString());
        return old;
    }

    public int getKeySize() {
        return Integer.parseInt(this.parameters.get(Parameter.KEYSIZE));
    }

    public int getBlockSize() {
        int bs;
        block3: {
            bs = 0;
            try {
                bs = Integer.parseInt(this.parameters.get(Parameter.BLOCKSIZE));
                if (bs < 128) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfe) {
                bs = Integer.parseInt(this.parameters.get(Parameter.KEYSIZE));
                if (bs >= 128) break block3;
                bs = -1;
            }
        }
        return bs;
    }

    public Mode getMode() {
        return Mode.getByString(this.parameters.get(Parameter.MODE));
    }

    public Mode setMode(Mode m) {
        Mode old = this.getMode();
        this.parameters.put(Parameter.MODE.getId(), m.toString());
        return old;
    }

    public boolean equals(Object key) {
        if (key == null) {
            return false;
        }
        if (key.getClass() != this.getClass()) {
            return false;
        }
        AsymmetricKey o = (AsymmetricKey)key;
        return this.dumpValueNotation("", DumpType.ALL_UNENCRYPTED).equals(o.dumpValueNotation("", DumpType.ALL_UNENCRYPTED));
    }

    public int hashCode() {
        return this.dumpValueNotation("", DumpType.ALL_UNENCRYPTED).hashCode();
    }

    public String toString() {
        return "([AsymmetricKey]hash=" + String.valueOf(this.privateKey != null ? Integer.valueOf(Arrays.hashCode(this.privateKey)) : "null") + "/" + String.valueOf(this.publicKey != null ? Integer.valueOf(Arrays.hashCode(this.publicKey)) : "null") + ";" + String.valueOf(this.parameters) + ")";
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
        Security.addProvider(new BouncyCastlePQCProvider());
        LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
        try {
            AsymmetricKey.setCacheFileName("AsymmetricKey.cache");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to set cache file name", e);
        }
    }
}

