/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.operation.BaseRemoveOperation;
import com.hazelcast.map.impl.operation.steps.DeleteOpSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class DeleteOperation
extends BaseRemoveOperation {
    boolean disableWanReplicationEvent;
    private boolean success;

    public DeleteOperation(String name, Data dataKey, boolean disableWanReplicationEvent) {
        super(name, dataKey);
        this.disableWanReplicationEvent = disableWanReplicationEvent;
    }

    public DeleteOperation() {
    }

    @Override
    protected void runInternal() {
        this.success = this.recordStore.delete(this.dataKey, this.getCallerProvenance());
    }

    @Override
    protected boolean disableWanReplicationEvent() {
        return this.disableWanReplicationEvent;
    }

    @Override
    public void applyState(State state) {
        super.applyState(state);
        this.success = state.getOldValue() != null;
    }

    @Override
    public Step getStartingStep() {
        return DeleteOpSteps.READ;
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public void afterRunInternal() {
        if (this.success) {
            super.afterRunInternal();
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.success;
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(false);
    }

    @Override
    public int getClassId() {
        return 28;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.disableWanReplicationEvent);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.disableWanReplicationEvent = in.readBoolean();
    }
}

