/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.locksupport.operations;

import com.hazelcast.internal.locksupport.LockStoreImpl;
import com.hazelcast.internal.locksupport.operations.AbstractLockOperation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.UUID;

public class UnlockBackupOperation
extends AbstractLockOperation
implements BackupOperation {
    private boolean force;
    private UUID originalCallerUuid;

    public UnlockBackupOperation() {
    }

    public UnlockBackupOperation(ObjectNamespace namespace, Data key, long threadId, UUID originalCallerUuid, boolean force) {
        super(namespace, key, threadId);
        this.force = force;
        this.originalCallerUuid = originalCallerUuid;
    }

    @Override
    public void run() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        boolean unlocked = this.force ? lockStore.forceUnlock(this.key) : lockStore.unlock(this.key, this.originalCallerUuid, this.threadId, this.getReferenceCallId());
        this.response = unlocked;
    }

    @Override
    public int getClassId() {
        return 15;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.originalCallerUuid);
        out.writeBoolean(this.force);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.originalCallerUuid = UUIDSerializationUtil.readUUID(in);
        this.force = in.readBoolean();
    }
}

