/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.locksupport;

import com.hazelcast.internal.locksupport.operations.IsLockedOperation;
import com.hazelcast.internal.locksupport.operations.LockOperation;
import com.hazelcast.internal.locksupport.operations.UnlockOperation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.TimeUtil;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class LockProxySupport {
    private final ObjectNamespace namespace;
    private final long maxLeaseTimeInMillis;

    public LockProxySupport(ObjectNamespace namespace, long maxLeaseTimeInMillis) {
        this.namespace = namespace;
        this.maxLeaseTimeInMillis = maxLeaseTimeInMillis;
    }

    public boolean isLocked(NodeEngine nodeEngine, Data key) {
        IsLockedOperation operation = new IsLockedOperation(this.namespace, key);
        InternalCompletableFuture f = this.invoke(nodeEngine, operation, key);
        return (Boolean)f.joinInternal();
    }

    private InternalCompletableFuture invoke(NodeEngine nodeEngine, Operation operation, Data key) {
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        return nodeEngine.getOperationService().invokeOnPartition("hz:impl:lockService", operation, partitionId);
    }

    public void lock(NodeEngine nodeEngine, Data key) {
        this.lock(nodeEngine, key, -1L);
    }

    public void lock(NodeEngine nodeEngine, Data key, long leaseTime) {
        leaseTime = this.getLeaseTime(leaseTime);
        LockOperation operation = new LockOperation(this.namespace, key, ThreadUtil.getThreadId(), leaseTime, -1L);
        InternalCompletableFuture f = this.invoke(nodeEngine, operation, key);
        if (!((Boolean)f.joinInternal()).booleanValue()) {
            throw new IllegalStateException();
        }
    }

    private long getLeaseTime(long leaseTime) {
        if (leaseTime > this.maxLeaseTimeInMillis) {
            throw new IllegalArgumentException("Max allowed lease time: " + this.maxLeaseTimeInMillis + "ms. Given lease time: " + leaseTime + "ms.");
        }
        if (leaseTime < 0L) {
            leaseTime = this.maxLeaseTimeInMillis;
        }
        return leaseTime;
    }

    public boolean tryLock(NodeEngine nodeEngine, Data key) {
        try {
            return this.tryLock(nodeEngine, key, 0L, TimeUnit.MILLISECONDS, -1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean tryLock(NodeEngine nodeEngine, Data key, long timeout, @Nullable TimeUnit timeunit) throws InterruptedException {
        return this.tryLock(nodeEngine, key, timeout, timeunit, -1L, TimeUnit.MILLISECONDS);
    }

    public boolean tryLock(NodeEngine nodeEngine, Data key, long timeout, @Nullable TimeUnit timeunit, long leaseTime, @Nullable TimeUnit leaseTimeunit) throws InterruptedException {
        long timeoutInMillis = TimeUtil.timeInMsOrTimeIfNullUnit(timeout, timeunit);
        long leaseTimeInMillis = TimeUtil.timeInMsOrTimeIfNullUnit(leaseTime, leaseTimeunit);
        LockOperation operation = new LockOperation(this.namespace, key, ThreadUtil.getThreadId(), leaseTimeInMillis, timeoutInMillis);
        InternalCompletableFuture f = this.invoke(nodeEngine, operation, key);
        try {
            return (Boolean)f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowInterrupted(t);
        }
    }

    public void unlock(NodeEngine nodeEngine, Data key) {
        UnlockOperation operation = new UnlockOperation(this.namespace, key, ThreadUtil.getThreadId());
        InternalCompletableFuture f = this.invoke(nodeEngine, operation, key);
        f.joinInternal();
    }

    public void forceUnlock(NodeEngine nodeEngine, Data key) {
        UnlockOperation operation = new UnlockOperation(this.namespace, key, -1L, true);
        InternalCompletableFuture f = this.invoke(nodeEngine, operation, key);
        f.joinInternal();
    }

    public ObjectNamespace getNamespace() {
        return this.namespace;
    }
}

