/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.metrics.RawJobMetrics;
import com.hazelcast.jet.impl.operation.AsyncJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class StartExecutionOperation
extends AsyncJobOperation {
    private long executionId;
    private boolean collectMetrics;

    public StartExecutionOperation() {
    }

    public StartExecutionOperation(long jobId, long executionId, boolean collectMetrics) {
        super(jobId);
        this.executionId = executionId;
        this.collectMetrics = collectMetrics;
    }

    protected CompletableFuture<RawJobMetrics> doRun() {
        return this.getJetServiceBackend().getJobExecutionService().beginExecution(this.getCallerAddress(), this.jobId(), this.executionId, this.collectMetrics);
    }

    @Override
    public int getClassId() {
        return 6;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeBoolean(this.collectMetrics);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.collectMetrics = in.readBoolean();
    }
}

