/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.Dumpable;
import net.messagevortex.asn1.HeaderRequest;
import net.messagevortex.asn1.HeaderRequestIdentity;
import net.messagevortex.asn1.HeaderRequestQueryQuota;
import net.messagevortex.asn1.HeaderRequestType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1TaggedObject;

public abstract class HeaderRequestFactory
extends AbstractBlock
implements Serializable,
Dumpable {
    public static final long serialVersionUID = 100000000007L;
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static final List<HeaderRequest> req = new ArrayList<HeaderRequest>();

    protected HeaderRequestFactory() {
    }

    public static HeaderRequest getInstance(ASN1Encodable ae) throws IOException {
        for (HeaderRequest hr : req) {
            if (HeaderRequestType.getByClass(hr.getClass()).getId() != ((ASN1TaggedObject)ae).getTagNo()) continue;
            return hr.getRequest(ae);
        }
        return null;
    }

    static {
        try {
            req.add(new HeaderRequestIdentity());
            req.add(new HeaderRequestQueryQuota());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception when adding Requests in static constructor", e);
        }
    }
}

